<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Schema;
use Spatie\Activitylog\Traits\LogsActivity;

/**
 * Class Warehousestore
 *
 * @property int $id
 * @property string $name
 * @property string $packed_column
 * @property string $yard_column
 * @property string $type
 * @property bool $default
 * @property bool $status
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Warehousestore extends Model
{
    use LogsActivity;

    protected $table = 'warehousestores';

    protected $casts = [
        'default' => 'bool',
        'status' => 'bool'
    ];

    protected $fillable = [
        'name',
        'packed_column',
        'yard_column',
        'type',
        'default',
        'status'
    ];


    public static  $validate = [
        'name' => 'required|unique:warehousestores,name',
        'type'=>'required'
    ];

    public static  $update = [
        'type'=>'required'
    ];

    public static $field = [
        'name',
        'packed_column',
        'yard_column',
        'type',
        'default',
        'status'
    ];


    public function setKeyAttribute(){
        $key = generateRandom(5);
        Schema::table("stockbatch", function (Blueprint $table) use(&$key) {
            $table->bigInteger($key)->default(0)->after("quantity");
        });
        $this->attributes['key'] = $key;
    }


    public function toggleDefault()
    {
        $this->default = !$this->default;
        $this->save();
    }



    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub

        self::creating(function($obj){
            $value = generateRandom(5);
            Schema::table("stockbatches", function (Blueprint $table) use(& $value) {
                $table->bigInteger("packed_".$value)->default(0)->after("quantity");
                $table->bigInteger("yard_".$value)->default(0)->after("quantity");
            });
            $obj->packed_column = "packed_".$value;
            $obj->yard_column = "yard_".$value;
        });


        self::deleting(function($obj){
            Schema::table('stockbatches', function (Blueprint $table) use(&$obj) {
                $table->dropColumn($obj->packed_column);
                $table->dropColumn($obj->yard_column);
            });
        });


        self::updated(function ($obj){
            getActiveStore(true);
        });

        self::created(function($obj){
            getActiveStore(true);
        });

    }


}
